'**********************************************************************
'Software License Agreement
 '
 ' The software supplied herewith by Microchip Technology Incorporated
 ' (the Company) for its PIC Microcontroller is intended and
 ' supplied to you, the Companys customer, for use solely and
 ' exclusively on Microchip PIC Microcontroller products. The
 ' software is owned by the Company and/or its supplier, and is
 ' protected under applicable copyright laws. All rights are reserved.
 ' Any use in violation of the foregoing restrictions may subject the
 ' user to criminal sanctions under applicable laws, as well as to
 ' civil liability for the breach of the terms and conditions of this
 ' license.
 '
 ' THIS SOFTWARE IS PROVIDED IN AN AS IS CONDITION. NO WARRANTIES,
 ' WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING, BUT NOT LIMITED
 ' TO, IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 ' PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. THE COMPANY SHALL NOT,
 ' IN ANY CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL OR
 ' CONSEQUENTIAL DAMAGES, FOR ANY REASON WHATSOEVER.
 '
 '*********************************************************************
 ' PICkit 2 PICBASIC PRO Demo for Low Pin Count Demo Board.
 ' For use with the PICBASIC PRO Compiler Demo version
 ' 
 ' This code uses the PIC16F690 ADC to read the value of the RP1
 ' potentiometer, and displays a "bar graph" on the LEDs of the 
 ' relative potentiometer value.
 ' Pressing the switch SW1 reverses the bar graph.  
 '
 ' To use the SW1 switch on the Low Pin Count Board
 ' the following must be completed:
 '
 ' 1) Copy the C:\Pk2 Lessons\LPC Demo Board\PICBASICPRO\16F690.INC file
 '    over the file included in the PICBASIC PRO demo directory, 
 '    PBPDEMO\16F690.INC
 '    This selects the MCLR pin be used as an input pin for SW1.  The edits
 '    are included here for reference:
 '      
 '      NOLIST
 ' ifdef PM_USED
 '      LIST
 '      include 'M16F6xx.INC'	; PM header
 '      device  pic16F690, intrc_osc_noclkout, wdt_on, mclr_off, protect_off
 '      XALL
 '      NOLIST
 '  else
 '      LIST
 '      LIST p = 16F690, r = dec, w = -302
 '      INCLUDE "P16F690.INC"	; MPASM  Header
 '      __config _INTRC_OSC_NOCLKOUT & _WDT_ON & _MCLRE_OFF & _CP_OFF
 '      NOLIST
 '  endif
 '      LIST
 ' 
 ' 2) Under Program>Settings Click on the "3-State on "Release from Reset" box
 '
 '
 '*********************************************************************/

' Define ADCIN parameters
Define	ADC_BITS	8	' Set number of bits in result
Define	ADC_CLOCK	1	' Set clock source (1=Fosc/8)

' Establish variables
adval	var	byte		' Create adval to store result
bars 	var byte
switchstate var bit

' Initialize Internal Registers

ANSEL =	1			' Intialize AN0 to A/D only
CM1CON0 = 0			' Initialize Comparator 1 off
CM2CON0 = 0			' Initialize Coparator 2 off
TRISC = 0			' PORTC all outputs for LEDs
TRISA = $FF			' PORTA all inputs for switch
PORTC = 0			' Preset LEDs off

'*** Main Program Loop ****
switchstate = 1		' Preset Switch State to Drive LEDs to Right

Main
'*** Read A/D value *****
	ADCIN 0, adval		' Read channel 0 to adval
		
	
'*** Drive LEDs *********	
	bars = (adval >> 6) 'Shift for 2 MSB for values 0 to 3
	if switchstate = 1 then			'Test for LED direction
	lookup bars,[1,3,7,15], PORTC	'Drive LEDs to Right
	else
	lookup bars,[8,12,14,15], PORTC	'Drive LEDs to Left
	endif

'*** Read State of Switch with 100 msec Debounce	
	if PORTA.3 = 0 then				'Switch is pressed
		pause 100					'Delay 100 msec
		if PORTA.3 = 0 then			'Test switch again
		switchstate = ~switchstate	'Toggle Switch State Flag
			hold
			if PORTA.3 = 0 then hold 'Wait for switch to be released
		endif
	endif

	goto main			'Loop back for new A/D sample

	